#include "mode1/erdiagram/Canvas.h"
#include "mode1/erdiagram/Arrow.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/Name.h"
#include "mode1/erdiagram/PrimaryKey.h"
#include "mode1/erdiagram/PrimaryKeysRect.h"
#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/erdiagram/Attribute.h"

#include <stdio.h>

Canvas::Canvas(QObject *parent) : QGraphicsScene(parent)
{
	this->mode = Mode(MoveItem);
	this->tableIndex = 0;
}

/*
void Canvas::Text(PrimaryKey* buffer)
{
	qDebug() << "PrimarykeyTest";
}
*/

void Canvas::mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent)
{
    if (mouseEvent->button() == Qt::LeftButton){
		
		Table* table;
		QPointF point;
		QString length;
		QPointF buf;

		switch (mode) {
			
			case InsertTable:
				(this->tableIndex)++;
				length.setNum(this->tableIndex);
				point = mouseEvent->scenePos();

				buf =  QPointF(0,0);

				table = new Table(buf, length);

				this->tables << table;

				this->addItem(table); 

				table->setPos(mouseEvent->scenePos());

				qDebug() << "ItemInsert";
				emit itemInserted(table);
				qDebug() << "ItemInsert11";
				break;
				
			case InsertLine1:
				line = new QGraphicsLineItem(QLineF(mouseEvent->scenePos() ,	mouseEvent->scenePos()));
				line->setPen(QPen(QColor(Qt::darkGreen), 2));
				addItem(line);

				//emit itemInserted(line);
				break;

			case InsertLine2:
				line = new QGraphicsLineItem(QLineF(mouseEvent->scenePos() ,	mouseEvent->scenePos()));
				line->setPen(QPen(QColor(Qt::red), 2));
				addItem(line);

				//emit itemInserted(line);
				break;

			case InsertLine3:
				line = new QGraphicsLineItem(QLineF(mouseEvent->scenePos() ,	mouseEvent->scenePos()));
				line->setPen(QPen(QColor(Qt::darkYellow), 2));
				addItem(line);

				//emit itemInserted(line);
				break;
				
			default:
				;
		}
	}

    QGraphicsScene::mousePressEvent(mouseEvent);
}

void Canvas::mouseMoveEvent(QGraphicsSceneMouseEvent *mouseEvent)
{
    if (mode == InsertLine1 && line != 0) {
        QLineF newLine(line->line().p1(), mouseEvent->scenePos());
        line->setLine(newLine);
    }
	else if (mode == InsertLine2 && line != 0) {
        QLineF newLine(line->line().p1(), mouseEvent->scenePos());
        line->setLine(newLine);
    }
	else if (mode == InsertLine3 && line != 0) {
        QLineF newLine(line->line().p1(), mouseEvent->scenePos());
        line->setLine(newLine);
    }
	else if(mode == MoveItem){
        QGraphicsScene::mouseMoveEvent(mouseEvent);
    }
}

void Canvas::mouseReleaseEvent(QGraphicsSceneMouseEvent *mouseEvent)
{
    if (line != 0 && ( mode == InsertLine1 || mode == InsertLine2 || mode == InsertLine3)) {

		qDebug() << "CurrentMode :" << this->mode;

        QList<QGraphicsItem *> startItems = items(line->line().p1());

		if (startItems.count() && startItems.last() == line){
            startItems.removeLast();
		}

        QList<QGraphicsItem *> endItems = items(line->line().p2());

        if (endItems.count() && endItems.last() == line){
            endItems.removeLast();
		}

        removeItem(line);
        delete line;

        if (startItems.count() > 0 && endItems.count() > 0 && startItems.last() != endItems.last()) {
            Table* startTable = qgraphicsitem_cast<Table *>(startItems.last());
            Table* endTable = qgraphicsitem_cast<Table *>(endItems.last());

			int arrowMode = 0;

			if(this->mode == 3){
				arrowMode = 1;
			}
			else if(this->mode == 4){
				arrowMode = 2;
			}
			else if(this->mode == 5){
				arrowMode = 3;
			}
			
            Arrow *arrow = new Arrow(startTable, endTable, arrowMode);
			
            arrow->setZValue(-1000.0);
			startTable->AddArrow(arrow);
			endTable->AddArrow(arrow);
			
            addItem(arrow);
			
			this->arrows << arrow;
			
			QList<PrimaryKey*> fkList = startTable->GetPrimaryRect()->GetPrimaryKeys();
			QStringList fkTextList;
			
			if( arrow->GetMode() == 1 ){
				// ȭǥ EndTable  StartTable  PK  FK  ִ κ...
				for(int i=0; i < fkList.count(); i++){
					
					// StartTable PK EndTable FK  ִ κ
					if( fkList[i]->toPlainText().contains("(FK)", Qt::CaseInsensitive) == false ){
						fkTextList << fkList[i]->toPlainText() + "(FK)";
					}
					
					// StartTable FK EndTable FK  ִ κ...
					else{
						fkTextList << fkList[i]->toPlainText();
					}
				}
				
				// EndTable PK   
				endTable->GetPrimaryRect()->InsertPrimaryKey(fkTextList);

			}

			else if( arrow->GetMode() == 3 ){
				// ȭǥ EndTable  StartTable  PK  FK  ִ κ...
				for(int i=0; i < fkList.count(); i++){
					
					// StartTable PK EndTable FK  ִ κ
					if( fkList[i]->toPlainText().contains("(FK)", Qt::CaseInsensitive) == false ){
						fkTextList << fkList[i]->toPlainText() + "(FK)";
					}
					
					// StartTable FK EndTable FK  ִ κ...
					else{
						fkTextList << fkList[i]->toPlainText();
					}
				}
				
				// EndTable PK   
			    endTable->GetAttributesRect()->InsertAttribute(fkTextList);
			}
		
            arrow->updatePosition();

			if( arrow->GetStartTable()->boundingRect().width() > arrow->GetEndTable()->boundingRect().width() ){
				double gap = arrow->GetStartTable()->boundingRect().width() - arrow->GetEndTable()->boundingRect().width();
				arrow->GetEndTable()->SetRect(gap);
			}
        }
		emit itemInserted(arrow);
    }

	for( int i=0; i<this->tables.count(); i++){
		(this->tables)[i]->ReSize();
	}

    line = 0;
    QGraphicsScene::mouseReleaseEvent(mouseEvent);
}

void Canvas::keyPressEvent ( QKeyEvent * keyEvent )
{
	qDebug() << "KeyPress";
	if( keyEvent->key() == Qt::Key_End ){
		
		QList<QGraphicsItem *> list = this->selectedItems();
		
		QList<Arrow*> deleteArrowList;
		
		int j=0;
		
		if( list.count() > 0 ){
			if( dynamic_cast<Table*>(list[0]) || dynamic_cast<Arrow*>(list[0]) ){
				
				if( dynamic_cast<Table*>(list[0]) ){
					
					QList<PrimaryKey*> deleteList;
					QList<Attribute*> deleteList2;
					
					for(j=0; j<this->tables.count(); j++){
						
						if( ((Table*)((this->tables)[j]))->pos() == ((Table*)(list[0]))->pos() ){
							break;
						}
					}
					
					for( int k=0; k < ((Table*)(list[0]))->GetArrows().count(); k++){
						
						if( (((Table*)(list[0]))->GetArrows())[k]->GetMode() == 1 ){
							
							// ȭǥ  ̺  ̺  ִ 
							if ((((Table*)(list[0]))->GetArrows())[k]->GetStartTable() == ((Table*)(list[0]))){
								//  ȭǥ List  
								deleteArrowList << (((Table*)(list[0]))->GetArrows())[k];
								// ش ȭǥ  ִ ̺  FK List 
								this->GetDeleteList((((Table*)(list[0]))->GetArrows())[k], deleteList);
							}
							
							// ȭǥ  ̺  ̺  ִ 
							else if ((((Table*)(list[0]))->GetArrows())[k]->GetEndTable() == ((Table*)(list[0]))){
								//  ȭǥ List  
								deleteArrowList << (((Table*)(list[0]))->GetArrows())[k];
								// ش ȭǥ  ִ ̺  FK List 
								this->GetDeleteList((((Table*)(list[0]))->GetArrows())[k], deleteList);
							}
						}
						
						else if( (((Table*)(list[0]))->GetArrows())[k]->GetMode() == 3 ){
							
							// ȭǥ  ̺  ̺  ִ 
							if ((((Table*)(list[0]))->GetArrows())[k]->GetStartTable() == ((Table*)(list[0]))){
								//  ȭǥ List  
								deleteArrowList << (((Table*)(list[0]))->GetArrows())[k];
								// ش ȭǥ  ִ ̺  FK List 
								this->GetDeleteList((((Table*)(list[0]))->GetArrows())[k], deleteList2);
							}
							
							// ȭǥ  ̺  ̺  ִ 
							else if ((((Table*)(list[0]))->GetArrows())[k]->GetEndTable() == ((Table*)(list[0]))){
								//  ȭǥ List  
								deleteArrowList << (((Table*)(list[0]))->GetArrows())[k];
								// ش ȭǥ  ִ ̺  FK List 
								this->GetDeleteList((((Table*)(list[0]))->GetArrows())[k], deleteList2);
							}
						}
					}
					
					QList<int> index;
					
					for( int k=0; k<deleteArrowList.count(); k++){
						int i = 0;
						
						//  ȭǥ ε ...
						while(i < this->arrows.count() && ((this->arrows)[i] != deleteArrowList[k]) ){
							if( (this->arrows)[i] == deleteArrowList[k] ){
								index << i;
							}
							i++;
						}
					}
					
					for(int i=0; i<deleteArrowList.count(); i++){
						for(int j=0; j<(this->tables).count(); j++){
							for(int k=0; k < ((this->tables)[j]->GetArrows()).count(); k++){
								if( ((this->tables)[j]->GetArrows())[k] == deleteArrowList[i] ){
									((this->tables)[j]->GetArrows()).removeAt(k);
								}
							}
						}
					}
					
					for( int i=0; i< deleteArrowList.count(); i++ ){
						delete deleteArrowList[i];
					}
					
					for( int k=0; k<deleteList.count(); k++){
						delete deleteList[k];
					}
					
					for( int k=0; k<deleteList2.count(); k++){
						delete deleteList2[k];
					}
					
					for( int i=0; i<index.count(); i++){
						this->arrows.removeAt(index[i]);
					}
					
					this->tables.removeAt(j);
					delete list[0];
				}
				
				
				else if( dynamic_cast<Arrow*>(list[0]) ){
					
					qDebug() << "dddddddddddddddd";
					
					for(j=0; j<this->arrows.count(); j++){
						
						if( ((Arrow*)(list[0]) == (this->arrows)[j]) == true ){
							break;
						}
					}
					
					// ̺  
					QList<PrimaryKey*> deleteList;
					QList<Attribute*> deleteList2;
					Arrow* arrow = (Arrow*)(list[0]);
					
					qDebug() << "ArrowMode :" << arrow->GetMode();
					
					if( arrow->GetMode() == 1 ){
						qDebug() << "DeleteCountddd";
						this->GetDeleteList(arrow, deleteList);
					}
					else if( arrow->GetMode() == 3 ){
						this->GetDeleteList(arrow, deleteList2);
						qDebug() << "DeleteCount :" << deleteList2.count();
					}
					else{
						qDebug() << "else";
					}
					
					for(int i=0; i<(this->tables).count(); i++){
						for(int k=0; k < ((this->tables)[i]->GetArrows()).count(); k++){
							if( ((this->tables)[i]->GetArrows())[k] == (Arrow*)(list[0]) ){
								((this->tables)[i]->GetArrows()).removeAt(k);
							}
						}
					}
					
					for( int i=0; i<deleteList.count(); i++){
						delete deleteList[i];
					}
					
					for( int i=0; i<deleteList2.count(); i++){
						delete deleteList2[i];
					}
					
					this->arrows.removeAt(j);
					delete list[0];
				}
			}
		}
		
		for( int i=0; i<this->tables.count(); i++){
			(this->tables)[i]->ReSize();
		}
	}
	
	QGraphicsScene::keyPressEvent(keyEvent);
}

void Canvas::GetDeleteList(Arrow* arrow, QList<PrimaryKey*>& deleteList)
{
	Table* startTable = arrow->GetStartTable();
	QStringList primaryKeyList;
	
	//  ̺ PK 
	for( int i=0; i<startTable->GetPrimaryRect()->GetPrimaryKeys().count(); i++){
		QString buffer = (startTable->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText();
		primaryKeyList << buffer;
	}
	
	Table* endTable = arrow->GetEndTable();
	
	//  ȭǥ  ̺   
	endTable->GetPrimaryRect()->DeletePrimaryKey(primaryKeyList, deleteList);
	
	//  ȭǥ  ̺  ִ ȭǥ  ̺   
	for(int i=0; i<endTable->GetArrows().count(); i++){
		if( (endTable->GetArrows())[i]->GetStartTable() == endTable ){
			
			(endTable->GetArrows())[i]->GetEndTable()->GetPrimaryRect()->DeletePrimaryKey(primaryKeyList, deleteList);
		}
	}
}

void Canvas::Save()
{
	//QList<Table*> tables;
	//QList<Arrow*> arrows;
	FILE* file;

	file = fopen("Canvas.txt", "wt");

	if( file != 0 ){
		// ̺  ... 
		fprintf(file, "%d\n", this->tables.count());

		for( int i=0; i<this->tables.count(); i++){
			// ̺ ġ 
			qDebug() << (this->tables)[i]->pos();
			fprintf(file, "%.2f %.2f\n", (this->tables)[i]->pos().x(), (this->tables)[i]->pos().y());

			qDebug() << (this->tables)[i]->boundingRect();
			fprintf(file, "%.2f %.2f %.2f %.2f\n", (this->tables)[i]->boundingRect().x(), (this->tables)[i]->boundingRect().y(),
				(this->tables)[i]->boundingRect().width(), (this->tables)[i]->boundingRect().height());

			NameRect* nameRect = (this->tables)[i]->GetNameRect();
			PrimaryKeysRect* primaryKeysRect = (this->tables)[i]->GetPrimaryRect();
			AttributesRect* attributesRect = (this->tables)[i]->GetAttributesRect();

			// ̺ ̸
			QString name = nameRect->GetName()->toPlainText();
			qDebug() << name.toStdString().c_str();
			fprintf(file, "%s\n", name.toStdString().c_str());

			// PK  
			qDebug() << primaryKeysRect->GetPrimaryKeys().count();
			fprintf(file, "%d\n", primaryKeysRect->GetPrimaryKeys().count());
			for(int j=0; j<primaryKeysRect->GetPrimaryKeys().count(); j++){
				QString pkName = (primaryKeysRect->GetPrimaryKeys())[j]->toPlainText();
				fprintf(file, "%s\n", pkName.toStdString().c_str());
			}

			// Attributs  
			fprintf(file, "%d\n", attributesRect->GetAttributes().count());
			
			for(int j=0; j<attributesRect->GetAttributes().count(); j++){
				QString attribute = (attributesRect->GetAttributes())[j]->toPlainText();
				fprintf(file, "%s\n", attribute.toStdString().c_str());
			}
		}

		fclose(file);
	}
}

void Canvas::Open()
{
	FILE* file;
	QString tableCount;
	QString tablePosX;
	QString tablePosY;
	QString tableRectX;
	QString tableRectY;
	QString tableRectWidth;
	QString tableRectHeight;
	QString tableName;
	QString pkLength;
	QString pkName;
	QString attributeLength;
	QString attributeName;
	
	file = fopen("Canvas.txt", "rt");
	
	char buffer[32] = {' ', };
	char buffer1[32] = {' ', };
	char buffer2[32] = {' ', };
	char buffer3[32] = {' ', };
	char buffer4[32] = {' ', };
	char buffer5[32] = {' ', };
	char buffer6[32] = {' ', };

	float buff1;
	float buff2;
	float buff3;
	float buff4;
	float buff5;
	float buff6;

	QList<QGraphicsItem *> items = this->items();

	for(int i=0; i<items.count(); i++){
		this->removeItem(items[i]);
	}

	if( file != 0 ){
		fgets(buffer, 32, file);
		tableCount = QString(buffer);
		tableCount = tableCount.trimmed();

		memset(buffer, 0, 32);
		
		for(int i=0; i<tableCount.toInt(); i++){

			fgets(buffer, 32, file);
			sscanf(buffer, "%f %f", &buff1, &buff2);
			//tablePosX = QString(buffer1);
			//tablePosY = QString(buffer2);
			memset(buffer, 0, 32);
			memset(buffer1, 0, 32);
			memset(buffer2, 0, 32);

			qDebug() << buff1;
			qDebug() << buff2;
			
			fgets(buffer, 32, file);
			sscanf(buffer, "%f %f %f %f", &buff3, &buff4, &buff5, &buff6);
			//tableRectX = QString(buffer1);
			//tableRectY = QString(buffer2);
			//tableRectWidth = QString(buffer3);
			//tableRectHeight = QString(buffer4);
			memset(buffer, 0, 32);
			memset(buffer3, 0, 32);
			memset(buffer4, 0, 32);
			memset(buffer5, 0, 32);
			memset(buffer6, 0, 32);

			QString length("3");
			Table* table = new Table(QPointF(buff1, buff2),length);
			
			fgets(buffer, 32, file);
			tableName = QString(buffer);
			tableName = tableName.trimmed();
			qDebug() << tableName;
			memset(buffer, 0, 32);

			table->GetNameRect()->GetName()->setPlainText(tableName);
			
			fgets(buffer, 32, file);
			pkLength = QString(buffer);
			pkLength = pkLength.trimmed();
			memset(buffer, 0, 32);

			qDebug() << pkLength;

			for(int j=0; j<pkLength.toInt(); j++){
				fgets(buffer, 32, file);
				pkName = QString(buffer);
				pkName = pkName.trimmed();
				memset(buffer, 0, 32);

				if( j == 0 ){
					(table->GetPrimaryRect()->GetPrimaryKeys())[j]->setPlainText(pkName);
					
				}

				else{
					qDebug() << "dddddddd";
					PrimaryKey* pk = new PrimaryKey(table->GetPrimaryRect()->boundingRect(), pkLength.toInt()-1,
						QString("ddd"), (QGraphicsItem*)(table->GetPrimaryRect()));
					qDebug() << "eeeeeeee";
					
					table->GetPrimaryRect()->GetPrimaryKeys() << pk;

					pk->setPlainText(pkName);
					qDebug() << "ffffffff";

					table->GetPrimaryRect()->SetRect(1);
				}

				qDebug() << pkName;
			}
			
			fgets(buffer, 32, file);
			attributeLength = QString(buffer);
			attributeLength = attributeLength.trimmed();
			memset(buffer, 0, 32);
			
			qDebug() << attributeLength;

			for(int j=0; j<attributeLength.toInt(); j++){
				fgets(buffer, 32, file);
				attributeName = QString(buffer);
				attributeName = attributeName.trimmed();
				memset(buffer, 0, 32);

				if( j == 0 ){
					(table->GetAttributesRect()->GetAttributes())[j]->setPlainText(attributeName);
				}

				else{
					Attribute* attribute = new Attribute(table->GetAttributesRect()->boundingRect(), attributeLength.toInt()-1,
							QString("ddd"), (QGraphicsItem*)(table->GetAttributesRect()));
					
					table->GetAttributesRect()->GetAttributes() << attribute;

					attribute->setPlainText(attributeName);

					table->GetAttributesRect()->SetRect(1);
				}

				qDebug() << attributeName;
			}

			this->addItem(table);
			table->ReSize();
		}

		qDebug() << "ddddd";
		
		fclose(file);
	}
}

void Canvas::GetDeleteList(Arrow* arrow, QList<Attribute*>& deleteList)
{
	Table* startTable = arrow->GetStartTable();
	QStringList primaryKeyList;
	
	//  ̺ PK 
	for( int i=0; i<startTable->GetPrimaryRect()->GetPrimaryKeys().count(); i++){
		QString buffer = (startTable->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText();
		primaryKeyList << buffer;
	}
	
	Table* endTable = arrow->GetEndTable();
	
	//  ȭǥ  ̺   
	endTable->GetAttributesRect()->DeleteAttribute(primaryKeyList, deleteList);
	
	//  ȭǥ  ̺  ִ ȭǥ  ̺   
	for(int i=0; i<endTable->GetArrows().count(); i++){
		if( (endTable->GetArrows())[i]->GetStartTable() == endTable ){
			
			(endTable->GetArrows())[i]->GetEndTable()->GetAttributesRect()->DeleteAttribute(primaryKeyList, deleteList);
		}
	}
}

void Canvas::CorrectTable(Table* table)
{
	QList<QGraphicsItem *> list = this->selectedItems();
	this->removeItem(list[0]);
	this->addItem(table);
}

void Canvas::editorLostFocus1(Name *item)
{
    QTextCursor cursor = item->textCursor();
    cursor.clearSelection();
    item->setTextCursor(cursor);
}

void Canvas::editorLostFocus2(PrimaryKey  *item)
{
    QTextCursor cursor = item->textCursor();
    cursor.clearSelection();
    item->setTextCursor(cursor);
}
void Canvas::editorLostFocus3(Attribute  *item)
{
    QTextCursor cursor = item->textCursor();
    cursor.clearSelection();
    item->setTextCursor(cursor);
}
Canvas::~Canvas()
{
	qDebug() << "~Canvas";
}
